/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.menuhandler;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.events.PlayWidgetClickSoundEvent;
import de.keksuccino.fancymenu.events.RenderGuiListBackgroundEvent;
import de.keksuccino.fancymenu.events.RenderWidgetBackgroundEvent;
import de.keksuccino.fancymenu.events.SoftMenuReloadEvent;
import de.keksuccino.fancymenu.mainwindow.MainWindowHandler;
import de.keksuccino.fancymenu.menu.animation.AdvancedAnimation;
import de.keksuccino.fancymenu.menu.animation.AnimationHandler;
import de.keksuccino.fancymenu.menu.button.ButtonCache;
import de.keksuccino.fancymenu.menu.button.ButtonCachedEvent;
import de.keksuccino.fancymenu.menu.button.ButtonData;
import de.keksuccino.fancymenu.menu.button.VanillaButtonDescriptionHandler;
import de.keksuccino.fancymenu.menu.fancy.DynamicValueHelper;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomization;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomizationProperties;
import de.keksuccino.fancymenu.menu.fancy.gameintro.GameIntroHandler;
import de.keksuccino.fancymenu.menu.fancy.guicreator.CustomGuiBase;
import de.keksuccino.fancymenu.menu.fancy.guicreator.CustomGuiLoader;
import de.keksuccino.fancymenu.menu.fancy.helper.MenuReloadedEvent;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.LayoutEditorScreen;
import de.keksuccino.fancymenu.menu.fancy.item.AnimationCustomizationItem;
import de.keksuccino.fancymenu.menu.fancy.item.ButtonCustomizationItem;
import de.keksuccino.fancymenu.menu.fancy.item.CustomizationItemBase;
import de.keksuccino.fancymenu.menu.fancy.item.ShapeCustomizationItem;
import de.keksuccino.fancymenu.menu.fancy.item.SlideshowCustomizationItem;
import de.keksuccino.fancymenu.menu.fancy.item.SplashTextCustomizationItem;
import de.keksuccino.fancymenu.menu.fancy.item.StringCustomizationItem;
import de.keksuccino.fancymenu.menu.fancy.item.TextureCustomizationItem;
import de.keksuccino.fancymenu.menu.fancy.item.VanillaButtonCustomizationItem;
import de.keksuccino.fancymenu.menu.fancy.item.WebStringCustomizationItem;
import de.keksuccino.fancymenu.menu.fancy.item.WebTextureCustomizationItem;
import de.keksuccino.fancymenu.menu.fancy.item.playerentity.PlayerEntityCustomizationItem;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.MenuHandlerRegistry;
import de.keksuccino.fancymenu.menu.panorama.ExternalTexturePanoramaRenderer;
import de.keksuccino.fancymenu.menu.panorama.PanoramaHandler;
import de.keksuccino.fancymenu.menu.slideshow.ExternalTextureSlideshowRenderer;
import de.keksuccino.fancymenu.menu.slideshow.SlideshowHandler;
import de.keksuccino.konkrete.gui.screens.popup.PopupHandler;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.properties.PropertiesSet;
import de.keksuccino.konkrete.rendering.CurrentScreenHandler;
import de.keksuccino.konkrete.rendering.RenderUtils;
import de.keksuccino.konkrete.rendering.animation.IAnimationRenderer;
import de.keksuccino.konkrete.resources.ExternalTextureResourceLocation;
import de.keksuccino.konkrete.resources.TextureHandler;
import de.keksuccino.konkrete.sound.SoundHandler;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IngameGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class MenuHandlerBase {
    protected List<CustomizationItemBase> frontRenderItems = new ArrayList<CustomizationItemBase>();
    protected List<CustomizationItemBase> backgroundRenderItems = new ArrayList<CustomizationItemBase>();
    protected Map<String, Boolean> audio = new HashMap<String, Boolean>();
    protected IAnimationRenderer backgroundAnimation = null;
    protected IAnimationRenderer lastBackgroundAnimation = null;
    protected List<IAnimationRenderer> backgroundAnimations = new ArrayList<IAnimationRenderer>();
    protected int backgroundAnimationId = 0;
    protected ExternalTextureResourceLocation backgroundTexture = null;
    protected String identifier;
    protected boolean backgroundDrawable;
    protected boolean panoramaback = false;
    protected int panoTick = 0;
    protected double panoPos = 0.0;
    protected boolean panoMoveBack = false;
    protected boolean panoStop = false;
    protected ExternalTexturePanoramaRenderer panoramacube;
    protected ExternalTextureSlideshowRenderer slideshow;
    protected List<ButtonData> hidden = new ArrayList<ButtonData>();
    protected Map<ButtonData, String> vanillaClickSounds = new HashMap<ButtonData, String>();
    protected Map<ButtonData, String> vanillaIdleTextures = new HashMap<ButtonData, String>();
    protected Map<ButtonData, String> vanillaHoverTextures = new HashMap<ButtonData, String>();
    protected Map<ButtonData, Float> delayAppearanceVanilla = new HashMap<ButtonData, Float>();
    protected Map<ButtonData, Float> fadeInVanilla = new HashMap<ButtonData, Float>();
    protected List<String> delayAppearanceFirstTime = new ArrayList<String>();
    protected List<Long> delayAppearanceFirstTimeVanilla = new ArrayList<Long>();
    protected List<ThreadCaller> delayThreads = new ArrayList<ThreadCaller>();
    protected boolean preinit = false;
    protected Map<String, RandomLayoutContainer> randomLayoutGroups = new HashMap<String, RandomLayoutContainer>();
    protected List<PropertiesSet> normalLayouts = new ArrayList<PropertiesSet>();
    protected SharedLayoutProperties sharedLayoutProps = new SharedLayoutProperties();
    protected String closeAudio;
    protected String openAudio;
    protected static Screen scaleChangedIn = null;

    public MenuHandlerBase(@Nonnull String identifier) {
        this.identifier = identifier;
    }

    public String getMenuIdentifier() {
        return this.identifier;
    }

    @SubscribeEvent
    public void onSoftReload(SoftMenuReloadEvent e) {
        if (this.shouldCustomize(e.screen)) {
            this.delayAppearanceFirstTimeVanilla.clear();
            this.delayAppearanceFirstTime.clear();
            this.delayAppearanceVanilla.clear();
            this.fadeInVanilla.clear();
            for (RandomLayoutContainer c : this.randomLayoutGroups.values()) {
                c.lastLayoutPath = null;
            }
            if (this.lastBackgroundAnimation != null) {
                this.lastBackgroundAnimation.resetAnimation();
            }
        }
    }

    @SubscribeEvent
    public void onMenuReloaded(MenuReloadedEvent e) {
        this.delayAppearanceFirstTimeVanilla.clear();
        this.delayAppearanceFirstTime.clear();
        this.delayAppearanceVanilla.clear();
        this.fadeInVanilla.clear();
        for (RandomLayoutContainer c : this.randomLayoutGroups.values()) {
            c.lastLayoutPath = null;
        }
        if (this.lastBackgroundAnimation != null) {
            this.lastBackgroundAnimation.resetAnimation();
        }
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public void onInitPre(GuiScreenEvent.InitGuiEvent.Pre e) {
        for (ThreadCaller t : this.delayThreads) {
            t.running.set(false);
        }
        this.delayThreads.clear();
        int mcscale = Minecraft.func_71410_x().func_228018_at_().func_216521_a(Minecraft.func_71410_x().field_71474_y.field_74335_Z, Minecraft.func_71410_x().func_211821_e());
        if (e.getGui() != Minecraft.func_71410_x().field_71462_r) {
            return;
        }
        if (scaleChangedIn != null && scaleChangedIn != e.getGui()) {
            scaleChangedIn = null;
            MainWindow m = Minecraft.func_71410_x().func_228018_at_();
            m.func_216525_a((double)mcscale);
            e.getGui().field_230708_k_ = m.func_198107_o();
            e.getGui().field_230709_l_ = m.func_198087_p();
        }
        if (!MenuCustomization.isValidScreen(e.getGui())) {
            return;
        }
        if (!this.shouldCustomize(e.getGui())) {
            return;
        }
        if (!AnimationHandler.isReady()) {
            return;
        }
        if (!GameIntroHandler.introDisplayed) {
            return;
        }
        if (LayoutEditorScreen.isActive) {
            return;
        }
        if (ButtonCache.isCaching()) {
            return;
        }
        if (!MenuCustomization.isMenuCustomizable(e.getGui())) {
            return;
        }
        this.preinit = true;
        List<PropertiesSet> rawLayouts = MenuCustomizationProperties.getPropertiesWithIdentifier(this.getMenuIdentifier());
        String defaultGroup = "-100397";
        this.normalLayouts.clear();
        for (RandomLayoutContainer randomLayoutContainer : this.randomLayoutGroups.values()) {
            randomLayoutContainer.onlyFirstTime = false;
            randomLayoutContainer.clearLayouts();
        }
        this.sharedLayoutProps = new SharedLayoutProperties();
        for (PropertiesSet propertiesSet : rawLayouts) {
            String randomMode;
            String smallerthanheight;
            String smallerthanwidth;
            String biggerthanheight;
            void var7_15;
            List list = propertiesSet.getPropertiesOfType("customization-meta");
            if (list.isEmpty()) {
                List list2 = propertiesSet.getPropertiesOfType("type-meta");
            }
            if (var7_15.isEmpty()) continue;
            Object biggerthanwidth = ((PropertiesSection)var7_15.get(0)).getEntryValue("biggerthanwidth");
            if (biggerthanwidth != null && MathUtils.isInteger((String)(biggerthanwidth = ((String)biggerthanwidth).replace(" ", "")))) {
                int i = Integer.parseInt((String)biggerthanwidth);
                if (MainWindowHandler.getWindowGuiWidth() < i) continue;
            }
            if ((biggerthanheight = ((PropertiesSection)var7_15.get(0)).getEntryValue("biggerthanheight")) != null && MathUtils.isInteger((String)(biggerthanheight = biggerthanheight.replace(" ", "")))) {
                int i = Integer.parseInt(biggerthanheight);
                if (MainWindowHandler.getWindowGuiHeight() < i) continue;
            }
            if ((smallerthanwidth = ((PropertiesSection)var7_15.get(0)).getEntryValue("smallerthanwidth")) != null && MathUtils.isInteger((String)(smallerthanwidth = smallerthanwidth.replace(" ", "")))) {
                int i = Integer.parseInt(smallerthanwidth);
                if (MainWindowHandler.getWindowGuiWidth() > i) continue;
            }
            if ((smallerthanheight = ((PropertiesSection)var7_15.get(0)).getEntryValue("smallerthanheight")) != null && MathUtils.isInteger((String)(smallerthanheight = smallerthanheight.replace(" ", "")))) {
                int i = Integer.parseInt(smallerthanheight);
                if (MainWindowHandler.getWindowGuiHeight() > i) continue;
            }
            if ((randomMode = ((PropertiesSection)var7_15.get(0)).getEntryValue("randommode")) != null && randomMode.equalsIgnoreCase("true")) {
                RandomLayoutContainer c;
                String group = ((PropertiesSection)var7_15.get(0)).getEntryValue("randomgroup");
                if (group == null) {
                    group = defaultGroup;
                }
                if (!this.randomLayoutGroups.containsKey(group)) {
                    this.randomLayoutGroups.put(group, new RandomLayoutContainer(group, this));
                }
                if ((c = this.randomLayoutGroups.get(group)) == null) continue;
                String randomOnlyFirstTime = ((PropertiesSection)var7_15.get(0)).getEntryValue("randomonlyfirsttime");
                if (randomOnlyFirstTime != null && randomOnlyFirstTime.equalsIgnoreCase("true")) {
                    c.setOnlyFirstTime(true);
                }
                c.addLayout(propertiesSet);
                continue;
            }
            this.normalLayouts.add(propertiesSet);
        }
        ArrayList<String> trashLayoutGroups = new ArrayList<String>();
        for (Map.Entry<String, RandomLayoutContainer> entry : this.randomLayoutGroups.entrySet()) {
            if (!entry.getValue().getLayouts().isEmpty()) continue;
            trashLayoutGroups.add(entry.getKey());
        }
        for (String string : trashLayoutGroups) {
            this.randomLayoutGroups.remove(string);
        }
        for (PropertiesSet propertiesSet : this.normalLayouts) {
            for (PropertiesSection sec : propertiesSet.getPropertiesOfType("customization")) {
                this.applyLayoutPre(sec, e);
            }
        }
        for (RandomLayoutContainer randomLayoutContainer : this.randomLayoutGroups.values()) {
            PropertiesSet s = randomLayoutContainer.getRandomLayout();
            if (s == null) continue;
            for (PropertiesSection sec : s.getPropertiesOfType("customization")) {
                this.applyLayoutPre(sec, e);
            }
        }
        if (!this.sharedLayoutProps.scaled && scaleChangedIn != null) {
            scaleChangedIn = null;
            MainWindow mainWindow = Minecraft.func_71410_x().func_228018_at_();
            mainWindow.func_216525_a((double)mcscale);
            e.getGui().field_230708_k_ = mainWindow.func_198107_o();
            e.getGui().field_230709_l_ = mainWindow.func_198087_p();
        }
    }

    protected void applyLayoutPre(PropertiesSection sec, GuiScreenEvent.InitGuiEvent.Pre e) {
        String action = sec.getEntryValue("action");
        if (action != null) {
            String scale;
            String identifier = sec.getEntryValue("identifier");
            if (action.equalsIgnoreCase("overridemenu") && identifier != null && CustomGuiLoader.guiExists(identifier)) {
                CustomGuiBase cus = CustomGuiLoader.getGui(identifier, null, e.getGui(), onClose -> e.getGui().func_231164_f_());
                Minecraft.func_71410_x().func_147108_a((Screen)cus);
            }
            if (action.contentEquals("setscale") && (scale = sec.getEntryValue("scale")) != null && (MathUtils.isInteger((String)scale.replace(" ", "")) || MathUtils.isDouble((String)scale.replace(" ", "")))) {
                scaleChangedIn = e.getGui();
                int newscale = (int)Double.parseDouble(scale.replace(" ", ""));
                if (newscale <= 0) {
                    newscale = 1;
                }
                MainWindow m = Minecraft.func_71410_x().func_228018_at_();
                m.func_216525_a((double)newscale);
                e.getGui().field_230708_k_ = m.func_198107_o();
                e.getGui().field_230709_l_ = m.func_198087_p();
                this.sharedLayoutProps.scaled = true;
            }
        }
    }

    @SubscribeEvent
    public void onButtonsCached(ButtonCachedEvent e) {
        if (e.getGui() != Minecraft.func_71410_x().field_71462_r) {
            return;
        }
        if (!MenuCustomization.isValidScreen(e.getGui())) {
            return;
        }
        if (!this.shouldCustomize(e.getGui())) {
            return;
        }
        if (!AnimationHandler.isReady()) {
            return;
        }
        if (!GameIntroHandler.introDisplayed) {
            return;
        }
        if (LayoutEditorScreen.isActive) {
            return;
        }
        if (ButtonCache.isCaching()) {
            return;
        }
        if (!MenuCustomization.isMenuCustomizable(e.getGui())) {
            return;
        }
        if (!this.preinit) {
            System.out.println("################ WARNING [FANCYMENU] ################");
            System.out.println("MenuHandler pre-init skipped! Trying to re-initialize menu!");
            System.out.println("Menu Type: " + e.getGui().getClass().getName());
            System.out.println("Menu Handler: " + this.getClass().getName());
            System.out.println("This probably happened because a mod has overridden a menu with this one.");
            System.out.println("#####################################################");
            e.getGui().func_231158_b_(Minecraft.func_71410_x(), e.getGui().field_230708_k_, e.getGui().field_230709_l_);
            return;
        }
        this.hidden.clear();
        this.delayAppearanceVanilla.clear();
        this.fadeInVanilla.clear();
        this.vanillaClickSounds.clear();
        this.vanillaIdleTextures.clear();
        this.vanillaHoverTextures.clear();
        this.audio.clear();
        this.frontRenderItems.clear();
        this.backgroundRenderItems.clear();
        this.panoramacube = null;
        this.slideshow = null;
        this.backgroundAnimation = null;
        this.backgroundAnimations.clear();
        if (this.backgroundAnimation != null && this.backgroundAnimation instanceof AdvancedAnimation) {
            ((AdvancedAnimation)this.backgroundAnimation).stopAudio();
        }
        this.backgroundDrawable = false;
        for (PropertiesSet propertiesSet : this.normalLayouts) {
            List metas = propertiesSet.getPropertiesOfType("customization-meta");
            if (metas.isEmpty()) {
                metas = propertiesSet.getPropertiesOfType("type-meta");
            }
            String renderOrder = ((PropertiesSection)metas.get(0)).getEntryValue("renderorder");
            for (PropertiesSection sec : propertiesSet.getPropertiesOfType("customization")) {
                this.applyLayout(sec, renderOrder, e);
            }
        }
        for (RandomLayoutContainer randomLayoutContainer : this.randomLayoutGroups.values()) {
            PropertiesSet s = randomLayoutContainer.getRandomLayout();
            if (s == null) continue;
            List metas = s.getPropertiesOfType("customization-meta");
            if (metas.isEmpty()) {
                metas = s.getPropertiesOfType("type-meta");
            }
            String renderOrder = ((PropertiesSection)metas.get(0)).getEntryValue("renderorder");
            for (PropertiesSection sec : s.getPropertiesOfType("customization")) {
                this.applyLayout(sec, renderOrder, e);
            }
        }
        MenuHandlerRegistry.setActiveHandler(this.getMenuIdentifier());
        for (Map.Entry entry : this.sharedLayoutProps.descriptions.entrySet()) {
            Widget w = ((ButtonData)entry.getKey()).getButton();
            if (w == null) continue;
            VanillaButtonDescriptionHandler.setDescriptionFor(w, (String)entry.getValue());
        }
        for (String string : MenuCustomization.getSounds()) {
            if (this.audio.containsKey(string) || string.equals(this.openAudio) || string.equals(this.closeAudio)) continue;
            SoundHandler.stopSound((String)string);
            SoundHandler.resetSound((String)string);
        }
        if (!this.sharedLayoutProps.closeAudioSet && this.closeAudio != null) {
            MenuCustomization.unregisterSound(this.closeAudio);
            this.closeAudio = null;
        }
        if (!this.sharedLayoutProps.openAudioSet && this.openAudio != null) {
            MenuCustomization.unregisterSound(this.openAudio);
            this.openAudio = null;
        }
        for (Map.Entry entry : this.audio.entrySet()) {
            SoundHandler.playSound((String)((String)entry.getKey()));
            if (!((Boolean)entry.getValue()).booleanValue()) continue;
            SoundHandler.setLooped((String)((String)entry.getKey()), (boolean)true);
        }
        if (!this.sharedLayoutProps.backgroundTextureSet) {
            this.backgroundTexture = null;
        }
        for (ButtonData buttonData : this.hidden) {
            buttonData.getButton().field_230694_p_ = false;
        }
        if (MenuCustomization.isNewMenu()) {
            for (CustomizationItemBase customizationItemBase : this.frontRenderItems) {
                this.handleAppearanceDelayFor(customizationItemBase);
            }
            for (CustomizationItemBase customizationItemBase : this.backgroundRenderItems) {
                this.handleAppearanceDelayFor(customizationItemBase);
            }
        }
        for (Map.Entry entry : this.delayAppearanceVanilla.entrySet()) {
            if (this.hidden.contains(entry.getKey())) continue;
            this.handleVanillaAppearanceDelayFor((ButtonData)entry.getKey());
        }
    }

    protected void applyLayout(PropertiesSection sec, String renderOrder, ButtonCachedEvent e) {
        String action = sec.getEntryValue("action");
        if (action != null) {
            String desc;
            File f;
            String clicks;
            String path;
            String value;
            String name;
            String identifier = sec.getEntryValue("identifier");
            Widget b = null;
            ButtonData bd = null;
            if (identifier != null && (bd = MenuHandlerBase.getButton(identifier)) != null) {
                b = bd.getButton();
            }
            if (action.equalsIgnoreCase("setbackgroundslideshow") && (name = sec.getEntryValue("name")) != null && SlideshowHandler.slideshowExists(name)) {
                this.slideshow = SlideshowHandler.getSlideshow(name);
            }
            if (action.equalsIgnoreCase("setbackgroundpanorama") && (name = sec.getEntryValue("name")) != null && PanoramaHandler.panoramaExists(name)) {
                this.panoramacube = PanoramaHandler.getPanorama(name);
            }
            if (action.equalsIgnoreCase("texturizebackground")) {
                File f2;
                value = sec.getEntryValue("path");
                String pano = sec.getEntryValue("wideformat");
                if (pano == null) {
                    pano = sec.getEntryValue("panorama");
                }
                if (value != null && (f2 = new File(value.replace("\\", "/"))).exists() && f2.isFile() && (f2.getName().toLowerCase().endsWith(".jpg") || f2.getName().toLowerCase().endsWith(".jpeg") || f2.getName().toLowerCase().endsWith(".png"))) {
                    if (this.backgroundTexture == null || !this.backgroundTexture.getPath().equals(value)) {
                        this.backgroundTexture = TextureHandler.getResource((String)value);
                    }
                    this.panoramaback = pano != null && pano.equalsIgnoreCase("true");
                    this.sharedLayoutProps.backgroundTextureSet = true;
                }
            }
            if (action.equalsIgnoreCase("animatebackground")) {
                value = sec.getEntryValue("name");
                String random = sec.getEntryValue("random");
                boolean ran = false;
                if (random != null && random.equalsIgnoreCase("true")) {
                    ran = true;
                }
                if (value != null) {
                    if (value.contains(",")) {
                        for (String s2 : value.split("[,]")) {
                            int i = 0;
                            for (char c : s2.toCharArray()) {
                                if (c != " ".charAt(0)) break;
                                ++i;
                            }
                            if (i > s2.length()) continue;
                            String temp = new StringBuilder(s2.substring(i)).reverse().toString();
                            int i2 = 0;
                            for (char c : temp.toCharArray()) {
                                if (c != " ".charAt(0)) break;
                                ++i2;
                            }
                            String name2 = new StringBuilder(temp.substring(i2)).reverse().toString();
                            if (!AnimationHandler.animationExists(name2)) continue;
                            this.backgroundAnimations.add(AnimationHandler.getAnimation(name2));
                        }
                    } else if (AnimationHandler.animationExists(value)) {
                        this.backgroundAnimations.add(AnimationHandler.getAnimation(value));
                    }
                    if (!this.backgroundAnimations.isEmpty()) {
                        if (ran) {
                            if (MenuCustomization.isNewMenu()) {
                                this.backgroundAnimationId = MathUtils.getRandomNumberInRange((int)0, (int)(this.backgroundAnimations.size() - 1));
                            }
                            this.backgroundAnimation = this.backgroundAnimations.get(this.backgroundAnimationId);
                        } else {
                            if (this.lastBackgroundAnimation != null && this.backgroundAnimations.contains(this.lastBackgroundAnimation)) {
                                this.backgroundAnimation = this.lastBackgroundAnimation;
                            } else {
                                this.backgroundAnimationId = 0;
                                this.backgroundAnimation = this.backgroundAnimations.get(0);
                            }
                            this.lastBackgroundAnimation = this.backgroundAnimation;
                        }
                    }
                }
            }
            if (action.equalsIgnoreCase("hidebuttonfor")) {
                String time = sec.getEntryValue("seconds");
                String onlyfirsttime = sec.getEntryValue("onlyfirsttime");
                String fadein = sec.getEntryValue("fadein");
                String fadeinspeed = sec.getEntryValue("fadeinspeed");
                if (b != null && MenuCustomization.isNewMenu()) {
                    boolean ft = false;
                    if (onlyfirsttime != null && onlyfirsttime.equalsIgnoreCase("true")) {
                        ft = true;
                    }
                    if (!(time == null || !MathUtils.isFloat((String)time) || ft && this.delayAppearanceFirstTimeVanilla.contains(bd.getId()))) {
                        this.delayAppearanceVanilla.put(bd, Float.valueOf(Float.parseFloat(time)));
                    }
                    if (ft && !this.delayAppearanceFirstTimeVanilla.contains(bd.getId())) {
                        this.delayAppearanceFirstTimeVanilla.add(bd.getId());
                    }
                    if (fadein != null && fadein.equalsIgnoreCase("true")) {
                        float speed = 1.0f;
                        if (fadeinspeed != null && MathUtils.isFloat((String)fadeinspeed)) {
                            speed = Float.parseFloat(fadeinspeed);
                        }
                        this.fadeInVanilla.put(bd, Float.valueOf(speed));
                    }
                }
            }
            if (action.equalsIgnoreCase("hidebutton") && b != null) {
                this.hidden.add(bd);
            }
            if ((action.equalsIgnoreCase("renamebutton") || action.equalsIgnoreCase("setbuttonlabel")) && (value = sec.getEntryValue("value")) != null && b != null) {
                value = DynamicValueHelper.convertFromRaw(value);
                b.func_238482_a_((ITextComponent)new StringTextComponent(value));
            }
            if (action.equalsIgnoreCase("resizebutton")) {
                String width = sec.getEntryValue("width");
                String height = sec.getEntryValue("height");
                if (width != null) {
                    width = DynamicValueHelper.convertFromRaw(width);
                }
                if (height != null) {
                    height = DynamicValueHelper.convertFromRaw(height);
                }
                if (width != null && height != null && b != null && MathUtils.isInteger((String)width) && MathUtils.isInteger((String)height)) {
                    b.func_230991_b_(Integer.parseInt(width));
                    b.setHeight(Integer.parseInt(height));
                }
            }
            if (action.equalsIgnoreCase("movebutton")) {
                String orientation;
                String posX = sec.getEntryValue("x");
                String posY = sec.getEntryValue("y");
                if (posX != null) {
                    posX = DynamicValueHelper.convertFromRaw(posX);
                }
                if (posY != null) {
                    posY = DynamicValueHelper.convertFromRaw(posY);
                }
                if ((orientation = sec.getEntryValue("orientation")) != null && posX != null && posY != null && b != null && MathUtils.isInteger((String)posX) && MathUtils.isInteger((String)posY)) {
                    int x = Integer.parseInt(posX);
                    int y = Integer.parseInt(posY);
                    int w = e.getGui().field_230708_k_;
                    int h = e.getGui().field_230709_l_;
                    if (orientation.equalsIgnoreCase("original")) {
                        b.field_230690_l_ += x;
                        b.field_230691_m_ += y;
                    }
                    if (orientation.equalsIgnoreCase("top-left")) {
                        b.field_230690_l_ = x;
                        b.field_230691_m_ = y;
                    }
                    if (orientation.equalsIgnoreCase("mid-left")) {
                        b.field_230690_l_ = x;
                        b.field_230691_m_ = h / 2 + y;
                    }
                    if (orientation.equalsIgnoreCase("bottom-left")) {
                        b.field_230690_l_ = x;
                        b.field_230691_m_ = h + y;
                    }
                    if (orientation.equalsIgnoreCase("top-centered")) {
                        b.field_230690_l_ = w / 2 + x;
                        b.field_230691_m_ = y;
                    }
                    if (orientation.equalsIgnoreCase("mid-centered")) {
                        b.field_230690_l_ = w / 2 + x;
                        b.field_230691_m_ = h / 2 + y;
                    }
                    if (orientation.equalsIgnoreCase("bottom-centered")) {
                        b.field_230690_l_ = w / 2 + x;
                        b.field_230691_m_ = h + y;
                    }
                    if (orientation.equalsIgnoreCase("top-right")) {
                        b.field_230690_l_ = w + x;
                        b.field_230691_m_ = y;
                    }
                    if (orientation.equalsIgnoreCase("mid-right")) {
                        b.field_230690_l_ = w + x;
                        b.field_230691_m_ = h / 2 + y;
                    }
                    if (orientation.equalsIgnoreCase("bottom-right")) {
                        b.field_230690_l_ = w + x;
                        b.field_230691_m_ = h + y;
                    }
                }
            }
            if (action.equalsIgnoreCase("setbuttontexture") && b != null) {
                String backNormal = sec.getEntryValue("backgroundnormal");
                String backHover = sec.getEntryValue("backgroundhovered");
                if (backNormal != null && backHover != null) {
                    this.vanillaIdleTextures.put(bd, backNormal);
                    this.vanillaHoverTextures.put(bd, backHover);
                }
            }
            if (action.equalsIgnoreCase("setbuttonclicksound") && b != null && (path = sec.getEntryValue("path")) != null) {
                this.vanillaClickSounds.put(bd, path);
            }
            if (action.equalsIgnoreCase("addhoversound") && b != null) {
                if (renderOrder != null && renderOrder.equalsIgnoreCase("background")) {
                    this.backgroundRenderItems.add(new VanillaButtonCustomizationItem(sec, bd));
                } else {
                    this.frontRenderItems.add(new VanillaButtonCustomizationItem(sec, bd));
                }
            }
            if (action.equalsIgnoreCase("sethoverlabel") && b != null) {
                if (renderOrder != null && renderOrder.equalsIgnoreCase("background")) {
                    this.backgroundRenderItems.add(new VanillaButtonCustomizationItem(sec, bd));
                } else {
                    this.frontRenderItems.add(new VanillaButtonCustomizationItem(sec, bd));
                }
            }
            if (action.equalsIgnoreCase("clickbutton") && b != null && (clicks = sec.getEntryValue("clicks")) != null && MathUtils.isInteger((String)clicks)) {
                for (int i = 0; i < Integer.parseInt(clicks); ++i) {
                    b.func_230982_a_((double)MouseInput.getMouseX(), (double)MouseInput.getMouseY());
                }
            }
            if (action.equalsIgnoreCase("addtext")) {
                if (renderOrder != null && renderOrder.equalsIgnoreCase("background")) {
                    this.backgroundRenderItems.add(new StringCustomizationItem(sec));
                } else {
                    this.frontRenderItems.add(new StringCustomizationItem(sec));
                }
            }
            if (action.equalsIgnoreCase("addwebtext")) {
                if (renderOrder != null && renderOrder.equalsIgnoreCase("background")) {
                    this.backgroundRenderItems.add(new WebStringCustomizationItem(sec));
                } else {
                    this.frontRenderItems.add(new WebStringCustomizationItem(sec));
                }
            }
            if (action.equalsIgnoreCase("addtexture")) {
                if (renderOrder != null && renderOrder.equalsIgnoreCase("background")) {
                    this.backgroundRenderItems.add(new TextureCustomizationItem(sec));
                } else {
                    this.frontRenderItems.add(new TextureCustomizationItem(sec));
                }
            }
            if (action.equalsIgnoreCase("addwebtexture")) {
                if (renderOrder != null && renderOrder.equalsIgnoreCase("background")) {
                    this.backgroundRenderItems.add(new WebTextureCustomizationItem(sec));
                } else {
                    this.frontRenderItems.add(new WebTextureCustomizationItem(sec));
                }
            }
            if (action.equalsIgnoreCase("addanimation")) {
                if (renderOrder != null && renderOrder.equalsIgnoreCase("background")) {
                    this.backgroundRenderItems.add(new AnimationCustomizationItem(sec));
                } else {
                    this.frontRenderItems.add(new AnimationCustomizationItem(sec));
                }
            }
            if (action.equalsIgnoreCase("addshape")) {
                if (renderOrder != null && renderOrder.equalsIgnoreCase("background")) {
                    this.backgroundRenderItems.add(new ShapeCustomizationItem(sec));
                } else {
                    this.frontRenderItems.add(new ShapeCustomizationItem(sec));
                }
            }
            if (action.equalsIgnoreCase("addslideshow")) {
                if (renderOrder != null && renderOrder.equalsIgnoreCase("background")) {
                    this.backgroundRenderItems.add(new SlideshowCustomizationItem(sec));
                } else {
                    this.frontRenderItems.add(new SlideshowCustomizationItem(sec));
                }
            }
            if (action.equalsIgnoreCase("addentity")) {
                if (renderOrder != null && renderOrder.equalsIgnoreCase("background")) {
                    this.backgroundRenderItems.add(new PlayerEntityCustomizationItem(sec));
                } else {
                    this.frontRenderItems.add(new PlayerEntityCustomizationItem(sec));
                }
            }
            if (action.equalsIgnoreCase("addbutton")) {
                ButtonCustomizationItem i = new ButtonCustomizationItem(sec);
                if (renderOrder != null && renderOrder.equalsIgnoreCase("background")) {
                    this.backgroundRenderItems.add(i);
                } else {
                    this.frontRenderItems.add(i);
                }
            }
            if (action.equalsIgnoreCase("addaudio") && ((Boolean)FancyMenu.config.getOrDefault("playbackgroundsounds", (Object)true)).booleanValue() && (Minecraft.func_71410_x().field_71441_e == null || ((Boolean)FancyMenu.config.getOrDefault("playbackgroundsoundsinworld", (Object)false)).booleanValue())) {
                File f3;
                path = sec.getEntryValue("path");
                String loopString = sec.getEntryValue("loop");
                boolean loop = false;
                if (loopString != null && loopString.equalsIgnoreCase("true")) {
                    loop = true;
                }
                if (path != null && (f3 = new File(path)).isFile() && f3.exists() && f3.getName().endsWith(".wav")) {
                    try {
                        String name3 = path + Files.size(f3.toPath());
                        MenuCustomization.registerSound(name3, path);
                        this.audio.put(name3, loop);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
            if (action.equalsIgnoreCase("setcloseaudio") && (path = sec.getEntryValue("path")) != null && (f = new File(path)).isFile() && f.exists() && f.getName().endsWith(".wav")) {
                try {
                    String name4 = "closesound_" + path + Files.size(f.toPath());
                    MenuCustomization.registerSound(name4, path);
                    this.closeAudio = name4;
                    this.sharedLayoutProps.closeAudioSet = true;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (action.equalsIgnoreCase("setopenaudio") && (path = sec.getEntryValue("path")) != null && (f = new File(path)).isFile() && f.exists() && f.getName().endsWith(".wav")) {
                try {
                    String name5 = "opensound_" + path + Files.size(f.toPath());
                    MenuCustomization.registerSound(name5, path);
                    SoundHandler.resetSound((String)name5);
                    SoundHandler.playSound((String)name5);
                    this.openAudio = name5;
                    this.sharedLayoutProps.openAudioSet = true;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (action.equalsIgnoreCase("setbuttondescription") && b != null && (desc = sec.getEntryValue("description")) != null) {
                this.sharedLayoutProps.descriptions.put(bd, DynamicValueHelper.convertFromRaw(desc));
            }
            if (action.equalsIgnoreCase("addsplash")) {
                String file = sec.getEntryValue("splashfilepath");
                String text = sec.getEntryValue("text");
                if (file != null || text != null) {
                    SplashTextCustomizationItem i = new SplashTextCustomizationItem(sec);
                    if (renderOrder != null && renderOrder.equalsIgnoreCase("background")) {
                        this.backgroundRenderItems.add(i);
                    } else {
                        this.frontRenderItems.add(i);
                    }
                }
            }
        }
    }

    protected void handleAppearanceDelayFor(final CustomizationItemBase i) {
        if (!(i instanceof VanillaButtonCustomizationItem) && i.delayAppearance) {
            if (i.getActionId() == null) {
                return;
            }
            if (!i.delayAppearanceEverytime && this.delayAppearanceFirstTime.contains(i.getActionId())) {
                return;
            }
            if (!i.delayAppearanceEverytime && !this.delayAppearanceFirstTime.contains(i.getActionId())) {
                this.delayAppearanceFirstTime.add(i.getActionId());
            }
            i.visible = false;
            if (i.fadeIn) {
                i.opacity = 0.1f;
            }
            final ThreadCaller c = new ThreadCaller();
            this.delayThreads.add(c);
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    long start = System.currentTimeMillis();
                    float delay = (float)(1000.0 * (double)i.delayAppearanceSec);
                    boolean fade = false;
                    while (c.running.get()) {
                        try {
                            long now = System.currentTimeMillis();
                            if (!fade) {
                                if (now >= start + (long)((int)delay)) {
                                    i.visible = true;
                                    if (!i.fadeIn) {
                                        return;
                                    }
                                    fade = true;
                                }
                            } else {
                                float o = i.opacity + 0.03f * i.fadeInSpeed;
                                if (o > 1.0f) {
                                    o = 1.0f;
                                }
                                if (i.opacity < 1.0f) {
                                    i.opacity = o;
                                } else {
                                    return;
                                }
                            }
                            Thread.sleep(50L);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
            t.start();
        }
    }

    protected void handleVanillaAppearanceDelayFor(final ButtonData d) {
        if (this.delayAppearanceVanilla.containsKey(d)) {
            final boolean fadein = this.fadeInVanilla.containsKey(d);
            final float delaysec = this.delayAppearanceVanilla.get(d).floatValue();
            d.getButton().field_230694_p_ = false;
            if (fadein) {
                d.getButton().func_230986_a_(0.1f);
            }
            final ThreadCaller c = new ThreadCaller();
            this.delayThreads.add(c);
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    float fadespeed = 1.0f;
                    if (fadein && MenuHandlerBase.this.fadeInVanilla.containsKey(d)) {
                        fadespeed = MenuHandlerBase.this.fadeInVanilla.get(d).floatValue();
                    }
                    float opacity = 0.1f;
                    long start = System.currentTimeMillis();
                    float delay = (float)(1000.0 * (double)delaysec);
                    boolean fade = false;
                    while (c.running.get()) {
                        try {
                            long now = System.currentTimeMillis();
                            if (!fade) {
                                if (now >= start + (long)((int)delay)) {
                                    d.getButton().field_230694_p_ = true;
                                    if (!fadein) {
                                        return;
                                    }
                                    fade = true;
                                }
                            } else {
                                float o = opacity + 0.03f * fadespeed;
                                if (o > 1.0f) {
                                    o = 1.0f;
                                }
                                if (opacity < 1.0f) {
                                    opacity = o;
                                    d.getButton().func_230986_a_(opacity);
                                } else {
                                    return;
                                }
                            }
                            Thread.sleep(50L);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
            t.start();
        }
    }

    @SubscribeEvent
    public void onRenderPost(GuiScreenEvent.DrawScreenEvent.Post e) {
        if (PopupHandler.isPopupActive()) {
            return;
        }
        if (!this.shouldCustomize(e.getGui())) {
            return;
        }
        if (!MenuCustomization.isMenuCustomizable(e.getGui())) {
            return;
        }
        if (!this.backgroundDrawable) {
            ArrayList<CustomizationItemBase> backItems = new ArrayList<CustomizationItemBase>();
            backItems.addAll(this.backgroundRenderItems);
            for (CustomizationItemBase i : backItems) {
                try {
                    i.render(e.getMatrixStack(), e.getGui());
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
        ArrayList<CustomizationItemBase> frontItems = new ArrayList<CustomizationItemBase>();
        frontItems.addAll(this.frontRenderItems);
        for (CustomizationItemBase i : frontItems) {
            try {
                i.render(e.getMatrixStack(), e.getGui());
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public void drawToBackground(GuiScreenEvent.BackgroundDrawnEvent e) {
        if (!MenuCustomization.isCurrentMenuScrollable()) {
            this.renderBackground(e.getMatrixStack(), e.getGui());
        }
    }

    protected void renderBackground(MatrixStack matrix, Screen s) {
        if (this.shouldCustomize(s)) {
            if (!MenuCustomization.isMenuCustomizable(s)) {
                return;
            }
            if (this.canRenderBackground()) {
                if (this.backgroundAnimation != null && this.backgroundAnimation.isReady()) {
                    boolean b = this.backgroundAnimation.isStretchedToStreensize();
                    this.backgroundAnimation.setStretchImageToScreensize(true);
                    this.backgroundAnimation.render(CurrentScreenHandler.getMatrixStack());
                    this.backgroundAnimation.setStretchImageToScreensize(b);
                } else if (this.backgroundTexture != null) {
                    RenderSystem.enableBlend();
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(this.backgroundTexture.getResourceLocation());
                    if (!this.panoramaback) {
                        IngameGui.func_238463_a_((MatrixStack)CurrentScreenHandler.getMatrixStack(), (int)0, (int)0, (float)1.0f, (float)1.0f, (int)(s.field_230708_k_ + 1), (int)(s.field_230709_l_ + 1), (int)(s.field_230708_k_ + 1), (int)(s.field_230709_l_ + 1));
                    } else {
                        int h;
                        int w = this.backgroundTexture.getWidth();
                        double ratio = (double)w / (double)(h = this.backgroundTexture.getHeight());
                        int wfinal = (int)((double)s.field_230709_l_ * ratio);
                        if (this.panoPos + (double)(wfinal - s.field_230708_k_) <= 0.0) {
                            this.panoMoveBack = true;
                        }
                        if (this.panoPos >= 0.0) {
                            this.panoMoveBack = false;
                        }
                        if (this.panoPos + (double)(wfinal - s.field_230708_k_) < 0.0) {
                            this.panoPos = 0 - (wfinal - s.field_230708_k_);
                        }
                        if (this.panoPos > 0.0) {
                            this.panoPos = 0.0;
                        }
                        if (!this.panoStop) {
                            if (this.panoTick >= 1) {
                                this.panoTick = 0;
                                this.panoPos = this.panoMoveBack ? (this.panoPos += 0.5) : (this.panoPos -= 0.5);
                                if (this.panoPos + (double)(wfinal - s.field_230708_k_) == 0.0) {
                                    this.panoStop = true;
                                }
                                if (this.panoPos == 0.0) {
                                    this.panoStop = true;
                                }
                            } else {
                                ++this.panoTick;
                            }
                        } else if (this.panoTick >= 300) {
                            this.panoStop = false;
                            this.panoTick = 0;
                        } else {
                            ++this.panoTick;
                        }
                        if (wfinal <= s.field_230708_k_) {
                            IngameGui.func_238463_a_((MatrixStack)CurrentScreenHandler.getMatrixStack(), (int)0, (int)0, (float)1.0f, (float)1.0f, (int)(s.field_230708_k_ + 1), (int)(s.field_230709_l_ + 1), (int)(s.field_230708_k_ + 1), (int)(s.field_230709_l_ + 1));
                        } else {
                            RenderUtils.doubleBlit((double)this.panoPos, (double)0.0, (float)1.0f, (float)1.0f, (int)wfinal, (int)(s.field_230709_l_ + 1));
                        }
                    }
                    RenderSystem.disableBlend();
                } else if (this.panoramacube != null) {
                    this.panoramacube.render();
                } else if (this.slideshow != null) {
                    int sw = this.slideshow.width;
                    int sh = this.slideshow.height;
                    int sx = this.slideshow.x;
                    int sy = this.slideshow.y;
                    this.slideshow.height = s.field_230709_l_;
                    this.slideshow.width = s.field_230708_k_;
                    this.slideshow.x = 0;
                    this.slideshow.y = 0;
                    this.slideshow.render(matrix);
                    this.slideshow.width = sw;
                    this.slideshow.height = sh;
                    this.slideshow.x = sx;
                    this.slideshow.y = sy;
                }
            }
            if (PopupHandler.isPopupActive()) {
                return;
            }
            ArrayList<CustomizationItemBase> backItems = new ArrayList<CustomizationItemBase>();
            backItems.addAll(this.backgroundRenderItems);
            for (CustomizationItemBase i : backItems) {
                try {
                    i.render(CurrentScreenHandler.getMatrixStack(), s);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            this.backgroundDrawable = true;
        }
    }

    @SubscribeEvent
    public void onButtonClickSound(PlayWidgetClickSoundEvent.Pre e) {
        if (this.shouldCustomize(Minecraft.func_71410_x().field_71462_r) && MenuCustomization.isMenuCustomizable(Minecraft.func_71410_x().field_71462_r)) {
            for (Map.Entry<ButtonData, String> m : this.vanillaClickSounds.entrySet()) {
                if (m.getKey().getButton() != e.getWidget()) continue;
                File f = new File(m.getValue());
                if (f.exists() && f.isFile() && f.getPath().toLowerCase().endsWith(".wav")) {
                    SoundHandler.registerSound((String)f.getPath(), (String)f.getPath());
                    SoundHandler.resetSound((String)f.getPath());
                    SoundHandler.playSound((String)f.getPath());
                }
                e.setCanceled(true);
                break;
            }
        }
    }

    @SubscribeEvent
    public void onButtonRenderBackground(RenderWidgetBackgroundEvent.Pre e) {
        if (this.shouldCustomize(Minecraft.func_71410_x().field_71462_r) && MenuCustomization.isMenuCustomizable(Minecraft.func_71410_x().field_71462_r)) {
            for (Map.Entry<ButtonData, String> m : this.vanillaIdleTextures.entrySet()) {
                ITextComponent msg;
                Widget w = m.getKey().getButton();
                if (w != e.getWidget()) continue;
                String idle = m.getValue();
                String hover = this.vanillaHoverTextures.get(m.getKey());
                if (hover == null || idle == null) break;
                ExternalTextureResourceLocation idleR = TextureHandler.getResource((String)idle);
                ExternalTextureResourceLocation hoverR = TextureHandler.getResource((String)hover);
                if (idleR == null || hoverR == null) break;
                if (!idleR.isReady()) {
                    idleR.loadTexture();
                }
                if (!hoverR.isReady()) {
                    hoverR.loadTexture();
                }
                if (w.func_230449_g_()) {
                    if (w.field_230693_o_) {
                        Minecraft.func_71410_x().field_71446_o.func_110577_a(hoverR.getResourceLocation());
                    } else {
                        Minecraft.func_71410_x().field_71446_o.func_110577_a(idleR.getResourceLocation());
                    }
                } else {
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(idleR.getResourceLocation());
                }
                RenderSystem.enableBlend();
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)e.getAlpha());
                AbstractGui.func_238463_a_((MatrixStack)e.getMatrixStack(), (int)w.field_230690_l_, (int)w.field_230691_m_, (float)0.0f, (float)0.0f, (int)w.func_230998_h_(), (int)w.func_238483_d_(), (int)w.func_230998_h_(), (int)w.func_238483_d_());
                if (w instanceof ImageButton && (msg = w.func_230458_i_()) != null) {
                    AbstractGui.func_238472_a_((MatrixStack)e.getMatrixStack(), (FontRenderer)Minecraft.func_71410_x().field_71466_p, (ITextComponent)msg, (int)(w.field_230690_l_ + w.func_230998_h_() / 2), (int)(w.field_230691_m_ + (w.func_238483_d_() - 8) / 2), (int)(w.getFGColor() | MathHelper.func_76123_f((float)(e.getAlpha() * 255.0f)) << 24));
                }
                e.setCanceled(true);
                break;
            }
        }
    }

    @SubscribeEvent
    public void onRenderListBackground(RenderGuiListBackgroundEvent.Post e) {
        Screen s = Minecraft.func_71410_x().field_71462_r;
        if (this.shouldCustomize(s) && MenuCustomization.isMenuCustomizable(s) && Minecraft.func_71410_x().field_71462_r != null) {
            this.renderBackground(e.getMatrixStack(), s);
        }
    }

    private static ButtonData getButton(String identifier) {
        if (identifier.startsWith("%id=")) {
            String p = identifier.split("[=]")[1].replace("%", "");
            if (!MathUtils.isLong((String)p)) {
                return null;
            }
            long id = Long.parseLong(p);
            ButtonData b = ButtonCache.getButtonForId(id);
            if (b != null) {
                return b;
            }
        } else {
            ButtonData b = null;
            b = I18n.func_188566_a((String)identifier) ? ButtonCache.getButtonForKey(identifier) : ButtonCache.getButtonForName(identifier);
            if (b != null) {
                return b;
            }
        }
        return null;
    }

    protected boolean shouldCustomize(Screen menu) {
        if (menu == null) {
            return false;
        }
        return this.getMenuIdentifier() == null || this.getMenuIdentifier().equals(menu.getClass().getName());
    }

    public boolean canRenderBackground() {
        return this.backgroundAnimation != null || this.backgroundTexture != null || this.panoramacube != null || this.slideshow != null;
    }

    public boolean setBackgroundAnimation(int id) {
        if (id < this.backgroundAnimations.size()) {
            this.backgroundAnimationId = id;
            this.lastBackgroundAnimation = this.backgroundAnimation = this.backgroundAnimations.get(id);
            return true;
        }
        return false;
    }

    public int getCurrentBackgroundAnimationId() {
        return this.backgroundAnimationId;
    }

    public List<IAnimationRenderer> backgroundAnimations() {
        return this.backgroundAnimations;
    }

    public static class SharedLayoutProperties {
        public boolean scaled = false;
        public boolean backgroundTextureSet = false;
        public boolean openAudioSet = false;
        public boolean closeAudioSet = false;
        public Map<ButtonData, String> descriptions = new HashMap<ButtonData, String>();
    }

    public static class RandomLayoutContainer {
        public final String id;
        protected List<PropertiesSet> layouts = new ArrayList<PropertiesSet>();
        protected boolean onlyFirstTime = false;
        protected String lastLayoutPath = null;
        public MenuHandlerBase parent;

        public RandomLayoutContainer(String id, MenuHandlerBase parent) {
            this.id = id;
            this.parent = parent;
        }

        public List<PropertiesSet> getLayouts() {
            return this.layouts;
        }

        public void addLayout(PropertiesSet layout) {
            this.layouts.add(layout);
        }

        public void addLayouts(List<PropertiesSet> layouts) {
            this.layouts.addAll(layouts);
        }

        public void clearLayouts() {
            this.layouts.clear();
        }

        public void setOnlyFirstTime(boolean b) {
            this.onlyFirstTime = b;
        }

        public boolean isOnlyFirstTime() {
            return this.onlyFirstTime;
        }

        public void resetLastLayout() {
            this.lastLayoutPath = null;
        }

        @Nullable
        public PropertiesSet getRandomLayout() {
            if (!this.layouts.isEmpty()) {
                String path;
                int i;
                PropertiesSet s;
                List metas;
                if ((this.onlyFirstTime || !MenuCustomization.isNewMenu()) && this.lastLayoutPath != null) {
                    File f = new File(this.lastLayoutPath);
                    if (f.exists()) {
                        for (PropertiesSet s2 : this.layouts) {
                            String path2;
                            List metas2 = s2.getPropertiesOfType("customization-meta");
                            if (metas2.isEmpty()) {
                                metas2 = s2.getPropertiesOfType("type-meta");
                            }
                            if (metas2.isEmpty() || (path2 = ((PropertiesSection)metas2.get(0)).getEntryValue("path")) == null || !path2.equals(this.lastLayoutPath)) continue;
                            return s2;
                        }
                    } else {
                        MenuCustomization.stopSounds();
                        MenuCustomization.resetSounds();
                        AnimationHandler.resetAnimations();
                        AnimationHandler.resetAnimationSounds();
                        AnimationHandler.stopAnimationSounds();
                    }
                }
                if ((metas = (s = this.layouts.get(i = MathUtils.getRandomNumberInRange((int)0, (int)(this.layouts.size() - 1)))).getPropertiesOfType("customization-meta")).isEmpty()) {
                    metas = s.getPropertiesOfType("type-meta");
                }
                if (!metas.isEmpty() && (path = ((PropertiesSection)metas.get(0)).getEntryValue("path")) != null) {
                    this.lastLayoutPath = path;
                    return s;
                }
            }
            return null;
        }
    }

    private static class ThreadCaller {
        AtomicBoolean running = new AtomicBoolean(true);

        private ThreadCaller() {
        }
    }
}

